define([
    'underscore',
    'backbone',
    'Layout',
    'modules/new-appointment-request/views/direct/clinics/layout-view',
    'modules/new-appointment-request/views/direct/clinics/single-clinic-view',
    'modules/new-appointment-request/views/direct/clinics/section-view',
    'modules/new-appointment-request/resources/direct/model',
    'modules/new-appointment-request/resources/direct/custom-messages/collection',
], function(
    _,
    Backbone,
    Layout,
    ClinicLayoutView,
    SingleClinicView,
    ClinicsSectionView,
    DirectModel,
    CustomMessagesCollection
) {
    'use strict';

    describe('Clinic Layout', function() {
        var view;
        var model;
        var clinicalServices;
        var clinicsTimeSlotsCollections;
        var layout;
        var customMessages;


        beforeEach(function() {
            layout = new Layout();
            model = new DirectModel({
                typeOfCare: new Backbone.Model({
                    id: '323',
                    name: 'PrimaryCare',
                }),
                facility: new Backbone.Model({institutionCode: '12345'}),
            });

            layout.render();

            customMessages = new CustomMessagesCollection([
                {
                    'id': 'noClinicRadioButtons',
                    'messageId': 'noClinicRadioButtons',
                    'messageText': 'This is a test.',
                },
            ]);

            spyOn(Backbone.Collection.prototype, 'fetch').and.callFake(_.noop);
            spyOn(SingleClinicView.prototype, 'initialize').and.callFake(_.noop);
            spyOn(ClinicsSectionView.prototype, 'initialize').and.callFake(_.noop);
        });

        describe('with one clinic', function() {
            beforeEach(function() {
                clinicalServices = new Backbone.Collection([
                    {
                        'id': '323',
                        'clinicalServiceIdentifier': {
                            'id': '323',
                            'name': 'PRIMARY CARE',
                        },
                        'isDirectSchedulingSupported': true,
                        'isRequestSupported': true,
                        'directSchedulingClinics': [
                            {
                                'id': '1779',
                                'name': "Dr. Evan's Clinic",
                                'friendlyName': "Dr. Evan's Clinic friendly name",
                            },
                        ],
                    },
                ]);

                clinicalServices.fetchData = _.noop;

                clinicsTimeSlotsCollections = new Backbone.Collection([
                    {
                        id: '1779',
                        appointmentTimeSlot: [],
                    },
                ]);

                view = new ClinicLayoutView({
                    model: model,
                    clinicsTimeSlotsCollections: clinicsTimeSlotsCollections,
                    customMessages: customMessages,
                });

                // override untested function
                view.onShow = _.noop;
                layout.showChildView('content', view);
            });

            it('should show SingleClinicView', function(done) {
                // TODO:  Creating a spy in 'it' is bad practice
                view.showChildView = jasmine.createSpy('showChildView').and.callFake(function(name, _view) {
                    expect(_view instanceof SingleClinicView).toBeTruthy();
                    done();
                });
                view.collection = clinicsTimeSlotsCollections;
                view.showClinics(clinicalServices);
            });
        });

        describe('with multiple clinics', function() {

            beforeEach(function() {
                clinicalServices = new Backbone.Collection([
                    {
                        'id': '323',
                        'clinicalServiceIdentifier': {
                            'id': '323',
                            'name': 'PRIMARY CARE',
                        },
                        'isDirectSchedulingSupported': true,
                        'isRequestSupported': true,
                        'directSchedulingClinics': [
                            {
                                'id': '1779',
                                'name': "Dr. Evan's Clinic",
                                'friendlyName': "Dr. Evan's Clinic friendly name",
                            },
                            {
                                'id': '124',
                                'name': "Dr. Deyne's Clinic",
                                'friendlyName': "Dr. Deyne's Clinic friendly name",
                            },
                            {
                                'id': '458',
                                'name': "Dr. Cross' Clinic",
                                'friendlyName': "Dr. Cross' Clinic friendly name",
                            },
                        ],
                    },
                ]);

                clinicsTimeSlotsCollections = new Backbone.Collection([
                    {
                        id: '1779',
                        timeSlots: [],
                    },
                    {
                        id: '124',
                        timeSlots: [],
                    },
                ]);

                view = new ClinicLayoutView({
                    model: model,
                    clinicsTimeSlotsCollections: clinicsTimeSlotsCollections,
                    customMessages: customMessages,
                });

                // override untested function
                view.onShow = _.noop;
                layout.showChildView('content', view);
            });

            it('should show ClinicsSectionView', function() {
                // TODO:  Creating a spy in 'it' is bad practice
                // TODO: This test will pass if 'show' is never called (false positive)
                view.showChildView = jasmine.createSpy('showChildView').and.callFake(function(name, _view) {
                    expect(Object.getPrototypeOf(_view)).toBe(ClinicsSectionView.prototype);
                });

                view.showClinics(clinicalServices);
            });
        });
    });
});
